// Initialize global variables
if (!variable_global_exists("fullscreen_enabled")) global.fullscreen_enabled = false;

// Initialize the leaderboard global variable
if (!variable_global_exists("leaderboard")) {
    global.leaderboard = ds_list_create(); // Create the leaderboard data structure
}

// Menu setup
width = 64;
height = 104;

last_selected = 0;

op_border = 8;
op_space = 16;

pos = 0;

// Main menu options
option[0] = ["New Game", "Load Game", "Settings", "Leaderboard", "Quit Game"];

// Settings menu options
option[1] = ["Window Size", "Controls", "Objective", "Back"];

// Window size submenu
option[2] = ["Window Size: 1x", "Window mode: Fullscreen", "Back"];

// Controls submenu
option[5] = [
    "Move Left: Left Arrow / A",
    "Move Right: Right Arrow / D",
    "Jump: Spacebar",
    "Pause: P",
    "Back"
];

// Objective submenu
option[4] = ["The objective of the game is to beat it as fast as possible.", "Back"];

// Leaderboard menu
option[3] = [];
if (ds_list_size(global.leaderboard) == 0) {
    array_push(option[3], "No entries yet");
} else {
    for (var i = 0; i < ds_list_size(global.leaderboard); i++) {
        array_push(option[3], string(i + 1) + ". " + ds_list_find_value(global.leaderboard, i));
    }
}
array_push(option[3], "Back to Main Menu"); // Add the back option to the bottom

// Name input submenu
option[6] = ["Enter your name: ", "Accept", "Back"];

// Initialize menu level
menu_level = 0; // Start at the main menu

// Variables for name input
global.player_name = ""; // Default name
name_input_active = false; // Whether the name input is currently active

// Function to calculate menu size
function calculate_menu_size() {
    width = 0;
    for (var i = 0; i < array_length(option[menu_level]); i++) {
        var _op_w = string_width(option[menu_level][i]);
        width = max(width, _op_w);
    }
    width += op_border * 2;

    // Ensure proper height calculation
    if (array_length(option[menu_level]) > 0) {
        height = op_border * 2 + string_height(option[menu_level][0]) + (array_length(option[menu_level]) - 1) * op_space;
    } else {
        height = op_border * 2; // Default height for empty menus
    }
}

// Initialize the menu dimensions
calculate_menu_size();
